unit Qrymain;


interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DBTables, StdCtrls, Dblup2, ExtCtrls, DB, Grids, DBGrids;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Query1: TQuery;
    RadioGroup1: TRadioGroup;
    DBLookupComboPlus1: TDBLookupComboPlus;
    Table1: TTable;
    BatchMove1: TBatchMove;
    DataSource1: TDataSource;
    Bevel1: TBevel;
    Memo1: TMemo;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure DBLookupComboPlus1PrepareList(Sender: TObject);
  private
    { Private declarations }
    LastRadioItemIndex : Integer;
{$IFNDEF Win32}
    function ImFirstInstance : Boolean;
    { The previous instance checking code in this unit comes from the
      post in the libs by Lee Sumner 100067,2216, who extended an original
      post by Pat Ritchey, famous author and Team B'er}
{$ENDIF}
  public
    { Public declarations }
  end;

{$IFNDEF Win32}
type
  PHWND = ^HWND;
  function EnumFunc(Wnd:HWND; TargetWindow:PHWND): bool; export;
{$ENDIF}

var
  Form1: TForm1;

implementation

{$R *.DFM}

{$IFNDEF Win32}
{ Wander the croud looking for dopplegangers }
function EnumFunc(Wnd:HWND; TargetWindow:PHWND): bool;
var
  ClassName : array[0..30] of char;
begin
  Result := true;
  if GetWindowWord(Wnd,GWW_HINSTANCE) = hPrevInst then
  begin
    GetClassName(Wnd,ClassName,30);
    if StrIComp(ClassName,'TApplication') = 0 then
    begin
      TargetWindow^ := Wnd;
      Result := false;
    end;
  end;
end;

function TForm1.ImFirstInstance : Boolean;
var
  HW: HWnd;
begin
  result := True;
  if hPrevinst <> 0 then  {If I am already running}
  begin
    EnumWindows(@EnumFunc,longint(@HW));
    if hw <> 0 then
      if IsIconic(HW) then
         ShowWindow(HW,SW_RESTORE)
      else
         BringWindowToTop(HW);
    result := False;
  end;
end;
{$ENDIF}

procedure TForm1.FormCreate(Sender: TObject);
begin
  {$IFNDEF Win32}
  { First make sure this is the only instance of the program }
  If not ImFirstInstance then halt;
  { Create the temporary table }
  { The reason the temporary is explictly created instead of just letting
    the batch move create it with a copy is that there is more control
    over where the table is created. Plus it's self documenting.
    Plus alot of people have been wondering how to create a table from
    inside Delphi so I figured I through it in.}
  {$ENDIF}
  with Table1 do
  begin
    Active := False;
    DatabaseName := Session.PrivateDir; {the safe place to put temporary files}
    TableName := 'DropList';
    TableType := ttParadox;
    with FieldDefs do
    begin
      Clear;
      Add('VendorName', ftString, 30, False);
    end;
    with IndexDefs do
    begin
      Clear;
      Add(''{'Field1Index'}, 'VendorName', [ixPrimary, ixUnique]);
      {This seconday index is created just cause I know how much
       you folks like caseinsenstive incremental searches}
      Add('byVendor', 'VendorName',[ixCaseInsensitive]);
    end;
    CreateTable;
  end;
  {Prepare the query}
  Query1.Active := False;
  Query1.Prepare;
  Query1.Active := True;
  { Move the data from the query result to the Temp Table.}
  BatchMove1.Execute;
  { Finish setting the TDBLookupCombosPlus's properties that could
    not be set at design time cause the table didn't exist yet.}
  DBLookupComboPlus1.LookupDisplay := 'VendorName';
  DBLookupComboPlus1.LookupIndex := 'byVendor';
  DBLookupComboPlus1.LookupField := 'VendorName';
  { finally open the table }
  Table1.Exclusive := True;    {make sure, real sure no one else messes with it}
  Table1.open;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  If Table1.TableName = 'DropList' then {deals with halt from instance checking} 
  begin
    Table1.Close;
    Table1.DeleteTable;
  end;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  { Pretty things up }
  Table1.First;
  DBLookupComboPlus1.value := Table1.FieldbyName('VendorName').AsString;
  DBLookupComboPlus1.SetFocus;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  DBLookupComboPlus1.SetFocus;
end;

procedure TForm1.DBLookupComboPlus1PrepareList(Sender: TObject);
begin
  { First check to make sure query needs to be re-done }
  If LastRadioItemIndex = RadioGroup1.ItemIndex then exit
  else
    LastRadioItemIndex := RadioGroup1.ItemIndex;
  { Redo the query }

  Query1.Close;
  case RadioGroup1.ItemIndex of
    0 : begin
          Query1.Params[0].AsBoolean := True;
          Query1.Params[1].AsBoolean := False;
        end;
    1 : begin
          Query1.Params[0].AsBoolean := True;
          Query1.Params[1].AsBoolean := True;
        end;
   end;
  Query1.Open;
  { Get the temp table ready for the new data}
  Table1.EmptyTable; {Didn't need to close it first since Exclusive was set to true below}
  { Move the data from the query result to the Temp Table}
  BatchMove1.Execute;
end;


end.
